/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.block_maps;

import com.moulberry.axiom.utils.BlockShapeUpdater;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4778;
import net.minecraft.class_5793;
import net.minecraft.class_5794;

public class FamilyMap {
    private static final Map<class_2248, class_5794> FAMILY_MAP = new HashMap<class_2248, class_5794>();
    private static final Map<class_2248, class_5794> BASE_MAP = new HashMap<class_2248, class_5794>();
    private static final Map<class_2248, class_5794.class_5796> FAMILY_VARIANT_MAP = new HashMap<class_2248, class_5794.class_5796>();
    private static final Map<class_5794.class_5796, Map<class_5794.class_5796, VariantConverter>> variantConverters;

    public static class_5794 getFamilyFor(class_2248 block) {
        return FAMILY_MAP.get(block);
    }

    public static class_5794 getFamilyForBase(class_2248 block) {
        return BASE_MAP.get(block);
    }

    public static class_5794.class_5796 getVariantFor(class_2248 block) {
        return FAMILY_VARIANT_MAP.get(block);
    }

    public static Map<class_5794.class_5796, VariantConverter> getVariantConverters(class_5794.class_5796 variant) {
        return variantConverters.get(variant);
    }

    static {
        class_5793.method_33467().forEach(blockFamily -> {
            FAMILY_MAP.put(blockFamily.method_33469(), (class_5794)blockFamily);
            BASE_MAP.put(blockFamily.method_33469(), (class_5794)blockFamily);
        });
        class_5793.method_33467().forEach(blockFamily -> {
            for (Map.Entry entry : blockFamily.method_33474().entrySet()) {
                if (FAMILY_MAP.containsKey(entry.getValue())) continue;
                FAMILY_MAP.put((class_2248)entry.getValue(), (class_5794)blockFamily);
                FAMILY_VARIANT_MAP.put((class_2248)entry.getValue(), (class_5794.class_5796)entry.getKey());
            }
        });
        variantConverters = new HashMap<class_5794.class_5796, Map<class_5794.class_5796, VariantConverter>>();
        VariantConverter identity = (from, to, pos, blockGetter) -> to;
        VariantConverter fenceToWall = (from, to, pos, blockGetter) -> {
            boolean north = (Boolean)from.method_11654((class_2769)class_2741.field_12489);
            boolean east = (Boolean)from.method_11654((class_2769)class_2741.field_12487);
            boolean south = (Boolean)from.method_11654((class_2769)class_2741.field_12540);
            boolean west = (Boolean)from.method_11654((class_2769)class_2741.field_12527);
            class_2338 abovePos = pos.method_10084();
            class_2680 above = blockGetter.method_8320(abovePos);
            class_265 aboveVoxelShape = above.method_26220(blockGetter, abovePos).method_20538(class_2350.field_11033);
            to = BlockShapeUpdater.updateWallSides(to, aboveVoxelShape, north, east, south, west);
            return BlockShapeUpdater.updateWallUp(to, above, aboveVoxelShape);
        };
        VariantConverter wallToFence = (from, to, pos, blockGetter) -> {
            boolean north = from.method_11654((class_2769)class_2741.field_22175) != class_4778.field_22178;
            boolean east = from.method_11654((class_2769)class_2741.field_22174) != class_4778.field_22178;
            boolean south = from.method_11654((class_2769)class_2741.field_22176) != class_4778.field_22178;
            boolean west = from.method_11654((class_2769)class_2741.field_22177) != class_4778.field_22178;
            to = (class_2680)to.method_11657((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(north));
            to = (class_2680)to.method_11657((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(east));
            to = (class_2680)to.method_11657((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(south));
            return (class_2680)to.method_11657((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(west));
        };
        variantConverters.put(class_5794.class_5796.field_28536, Map.of(class_5794.class_5796.field_40592, identity, class_5794.class_5796.field_28544, fenceToWall));
        variantConverters.put(class_5794.class_5796.field_40592, Map.of(class_5794.class_5796.field_28536, identity, class_5794.class_5796.field_28544, fenceToWall));
        variantConverters.put(class_5794.class_5796.field_28544, Map.of(class_5794.class_5796.field_28536, wallToFence, class_5794.class_5796.field_40592, wallToFence));
        variantConverters.put(class_5794.class_5796.field_28537, Map.of(class_5794.class_5796.field_40593, identity));
        variantConverters.put(class_5794.class_5796.field_40593, Map.of(class_5794.class_5796.field_28537, identity));
    }

    @FunctionalInterface
    public static interface VariantConverter {
        public class_2680 convert(class_2680 var1, class_2680 var2, class_2338 var3, class_1922 var4);
    }
}

